/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.CommonDataAnalysisRoutine;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public abstract class DistributedDataEventAnalysisRoutine
extends CommonDataAnalysisRoutine {
    private static final String TRACE_MASKT = "XPADDEAT";
    private static final String TRACE_MASKF = "XPADDEAF";
    private static final String TRACE_MASKD = "XPADDEAD";

    protected void processEvent(DistributedDataEvent theEvent) {
        super.processEvent(theEvent);
        if (this.anIncident != null) {
            CommonProblem aProblem = this.anIncident.getProblem();
            if (aProblem == null) {
                return;
            }
            aProblem.setRefcode(theEvent.getRefcode());
            aProblem.setExtension(theEvent.getExtension());
            aProblem.setSkipVPD(false);
            aProblem.setSkipRSF(false);
            aProblem.setReplicatable(true);
            this.anIncident.setPriority(theEvent.getPriority());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncidentPool getPendingIncidentPool(String poolId, DistributedDataEvent event, long waitTime) {
        Trace.trace(TRACE_MASKF, "getting the incident pool [" + poolId + "]");
        long lastReportedTS = event.getFirstReportedTime();
        IncidentPool aPool = null;
        HashMap hashMap = _pendingPoolMap;
        synchronized (hashMap) {
            Set poolKeys = _pendingPoolMap.keySet();
            Iterator pkI = poolKeys.iterator();
            while (pkI.hasNext()) {
                int indexOfSeparator;
                String poolName = (String)pkI.next();
                if (poolName.indexOf(poolId) == -1 || (indexOfSeparator = poolName.indexOf("//")) == -1) continue;
                long poolTS = Long.parseLong(poolName.substring(indexOfSeparator + 2));
                if (event.getFirstReportedTime() < poolTS || event.getFirstReportedTime() > poolTS + waitTime) continue;
                aPool = (IncidentPool)_pendingPoolMap.get(poolName);
            }
            if (aPool == null) {
                Trace.trace(TRACE_MASKF, "didn't find the ip key. New up one.");
                aPool = new IncidentPool(poolId + "//" + event.getFirstReportedTime());
                _pendingPoolMap.put(aPool.getPoolId(), aPool);
                Log theLog = new Log(-86, 70, 0, "PA START", null, null, null, null);
                String dataString = "created pool id=" + aPool.getPoolId();
                theLog.add((byte)3, dataString);
                theLog.log();
            } else {
                Trace.trace(TRACE_MASKF, "already have pool with id [" + aPool.getPoolId() + "]");
            }
        }
        return aPool;
    }

    protected void reportIncident(DistributedDataEvent event, CommonServiceIncident anIncident, CommonServiceAREvent timeoutEvent, int timeoutValue) {
        Trace.trace(TRACE_MASKD, "--> reportIncident()");
        IncidentPool thePool = this.getPendingIncidentPool(event.getIncidentPoolId(), event, timeoutValue);
        Trace.trace(TRACE_MASKD, "thePool to add to is " + thePool.getPoolId());
        timeoutEvent.setSystem(event.getSystem());
        timeoutEvent.setIncidentPoolId(thePool.getPoolId());
        anIncident.setTimerEvent(timeoutEvent);
        Boolean delayed = (Boolean)event.getMetaData().getMeta("pdc_DELAYED_LOG");
        if (delayed != null) {
            anIncident.getProblem().setDelayed(delayed);
        }
        if (this.eventManager == null) {
            Trace.trace(TRACE_MASKD, ">>>>>>> event manager is NULL!!!!!!!!");
        }
        anIncident.setEventManager(this.eventManager);
        anIncident.schedule(timeoutValue * 1000);
        thePool.add(anIncident);
        Trace.trace(TRACE_MASKD, "<-- reportIncident()");
    }
}

